package furny.swing.admin.statistics.chart;

import java.util.Map.Entry;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

import furny.ga.logger.DataCache;

/**
 * The Class MaxFitnessTimeChart. The charts are just experimental and not
 * documented yet.
 * 
 * @since 12.08.2012
 * @author Stephan Dreyer
 */
public class MaxFitnessTimeChart implements IChartSettings {
  @Override
  public JFreeChart createChart(final long runId) {

    final XYSeries series = new XYSeries("Fitness(max) over time");

    for (final Entry<Double, Double> entry : DataCache.getInstance()
        .getMaxFitnessTime(runId).entrySet()) {
      series.add(entry.getKey(), entry.getValue());
    }

    final XYDataset xyDataset = new XYSeriesCollection(series);
    final JFreeChart chart = ChartFactory.createXYLineChart(null, // Title
        "Time in seconds", // X-Axis label
        "Fitness", // Y-Axis label
        xyDataset, // Dataset
        PlotOrientation.VERTICAL, //
        true, // Show legend
        true, // show tooltips
        false); // show urls

    // final XYPlot plot = (XYPlot) chart.getPlot();

    // final DateAxis ta = (DateAxis) plot.getDomainAxis();
    // ta.setTickUnit(new DateTickUnit(DateTickUnitType.SECOND, 10));
    // ta.setDateFormatOverride(new SimpleDateFormat(""));

    // NumberAxis na = (NumberAxis) plot.getDomainAxis();
    // na.setTickUnit(new NumberTickUnit(10d));
    // na.setRangeType(RangeType.POSITIVE);

    // na = (NumberAxis) plot.getRangeAxis();
    // na.setTickUnit(new NumberTickUnit(1d));

    // plot.setRenderer(ChartUtil.getBarRenderer());

    return chart;
  }

  @Override
  public String toString() {
    return "Fitness(max) / Time";
  }
}
